% *************************************************************************
% 
%                      iGem Modelling - 2018
%                     Delft University of Technology
% 
% *************************************************************************
% 
%               Title
% 
%                    File: Extra Graphs: CFU-E apoptosis, marrow transit
%                    time, and RBCs feedback loop on natural EPO
%                    production
%                           
% 
%              
% *************************************************************************
clear all
close all

%Create EPO level range
Et = linspace(0,70);

%Create Red Blood Cell count range
RBCs = linspace(10e12,40e12);
RBCs_graph = RBCs./1e12;
TBV = 5000;
Mt = 1e-8.*RBCs./5000;

%Bone Marrow Reticulocyte Marrow Transit Time variables
a2 = 2; b2 = 0.35;
c2 = 2.3; k2 = 0.2;

%Calculate Reticulocyte Marrow Transit Time
vs = (a2-b2)./(1+exp(-k2*Et+c2)) + b2;
vs2 = 3 - (3-0.75)*(vs-0.5)/(2-0.5);
%plot

% CFU-E Apoptosis Rate variables
a1 = 0.35; b1 = 0.07;
c1 = 3; k1 = 0.14;


%Calculate CFU-E Apoptosis Rate
alpha_q = (a1-b1)./(1+exp(k1*Et-c1)) + b1
Bq = 0.57
growth_rate = Bq - alpha_q

%Endogenous EPO Release
a3 = 16500; b3 = 117000;
c3 = 9.1; k3 = 0.2;
Et_end_in = (b3-a3)./(1+exp(k3*Mt - c3)) + a3;

%Marrow Transit Time Figure
figure(1)
plot(Et,vs2, 'LineWidth',2); hold on;
xlabel('EPO Concentration (mU/mL)', 'FontSize', 14) 
ylabel('Marrow Transit Time (days)', 'FontSize', 14)
set(gca,'fontsize',16)
set(gcf,'color','w'); 
xlim([0 50])

%CFU-E Apoptosis Figure
figure(2)
plot(Et, alpha_q, 'LineWidth',2)
xlabel('EPO Concentration (mU/mL)', 'FontSize', 14) 
ylabel('CFU-E Apoptosis Rate (1/day)', 'FontSize', 14)
set(gca,'fontsize',16)
set(gcf,'color','w'); 
xlim([0 70])

%RBCs feedback loop graph
figure(5)
plot(RBCs_graph, Et_end_in/5000, 'LineWidth',2)
xlabel('Red Blood Cell Population (# of cells x10^{12})', 'FontSize', 14) 
ylabel('EPO Released from Kidneys (mU/day/)', 'FontSize', 14)
set(gca,'fontsize',16)
set(gcf,'color','w'); 
